
#################### Ullah (1985) test ####################

res.sp=ohs.res(data=D)
h=res.sp$band
u=res.sp$resid
u=as.matrix(u)

res.p=tsls.res(data=E)
u1=res.p$resid1
u1=as.matrix(u1)
u2=res.p$resid2
u2=as.matrix(u2)
u3=res.p$resid3
u3=as.matrix(u3)
f1=res.p$fitted1
f1=as.matrix(f1)
f2=res.p$fitted2
f2=as.matrix(f2)
f3=res.p$fitted3
f3=as.matrix(f3)
f11=res.p$fitted11
f11=as.matrix(f11)
c11=res.p$coef11
c11=as.matrix(c11)

ssr.sp=t(u)%*%u
ssr.p=t(u1)%*%u1
stat=(ssr.p-ssr.sp)/ssr.sp

#################### wild bootstrapped Ullah (1985) test ####################

set.seed(123456)

s=nrow(E)

u1.c=u1-mean(u1)
u2.c=u2-mean(u2)
u3.c=u3-mean(u3)

nb=399

boot.stat=numeric(nb)

for(j in 1:nb){

unif=runif(s,0,1)

a=(1-sqrt(5))/2
b=(1+sqrt(5))/2
prob.a=(sqrt(5)+1)/(2*sqrt(5))

u1.b=ifelse(unif<=prob.a,a*u1.c,b*u1.c)
u2.b=ifelse(unif<=prob.a,a*u2.c,b*u2.c)
u3.b=ifelse(unif<=prob.a,a*u3.c,b*u3.c)

x1.star=f2+u2.b
x2.star=f3+u3.b

x.star=cbind(x1.star,x2.star)
f11.b=x.star%*%c11

y.star=f1-f11+f11.b+u1.b

D.b=D
D.b[,1]=y.star

E.b=E
E.b[,1]=y.star

res.sp.b=ohs.res.b(data=D.b,bandwidth=h)
u.bb=res.sp.b$resid
u.bb=as.matrix(u.bb)

res.p.b=tsls.res(data=E.b)
u1.bb=res.p.b$resid1
u1.bb=as.matrix(u1.bb)

ssr.sp.b=t(u.bb)%*%u.bb
ssr.p.b=t(u1.bb)%*%u1.bb
stat.b=(ssr.p.b-ssr.sp.b)/ssr.sp.b

boot.stat[j]=stat.b

}

########## statistic and p-value ##########

rank.stat=rank(c(stat,boot.stat)) 
p.value=1-(rank.stat[1]/(nb+1))
stat
p.value
